#########################################################################
#Titre: Start.py
#Depuis: 27/01/2014
#A participé: Lucas, Vivien, Nicolas
#
#Description: Fichier principal du jeu
#
#Dernière modification: 11/05/2014 vivien
#########################################################################
#----------------------------------------------------------------------
#Commentaires
#----------------------------------------------------------------------

#La Liste p (crée dans charger_jeu, nouvelle_partie, recommencer) et la base de
#notre communication entre fonctions
#Voila la liste des éléments qu'elle contient avec leur indices:
#
# fen(0) , terrain(1) , LMob(2) , LTour(3) , Chemin(4) , Pause(5) , Selection(6) , Vie(7) ,
# Argent(8) , chateau(9) , PlacerSelect(10) , LCase(11) , LVague(12) , CadreInfo(13) ,
# 'TourBouton'(14) , Stop(15) , 'CadreVague'(16) , XP(17) , cible(18) , temps_passe(19) ,
# 'affiche_temp'(20) , 'bouton_option'(21) , gagner(22) 


#La condition:
#if not p[5]:
#elif not p[15] : p[0].after(100 , nom_de_fonction , argument1, argument2)
#=> permet de faire tourner une boucle en arrière plan qui se répète toutes les 100ms si le jeu est en pause (p5)
#pour permettre de relancer la fonction quand la pause sera fini
#=> et de stopper tout si la pause se transforme et stop (p15)

#----------------------------------------------------------------------
#Initialisation
#----------------------------------------------------------------------
#On importe les modules nécessaires au script
from page_chargement import * #cette importation permet d'ouvrir la fenetre de chargement
from tkinter import *
from math import *
from pickle import *
from tkinter.filedialog import *
from copy import *
import webbrowser
import sys
import subprocess


#Importation des fichiers systemes
from entite import *
#on importe les images nécessaires à creer_jeu et menu
from info import Tour1,Tour2,Tour3,BGMenu

#Configuration de la fenetre
f.resizable( width=False , height=False)
#Changement du titre et de l'icone de la fenetre
f.title("Tower Defence")
f.iconbitmap('img/Icone.ico')

#----------------------------------------------------------------------
#Définition des fonctions de mécanisme
#----------------------------------------------------------------------

#====== Fonctions permettant d'étaler la détection des tours dans le temps ======
def DetectionTourPrincipal(p):
	"""Cette fonction tourne en boucle et lance toutes les secondes la fonction
		DetectionTour2
	"""
	if not p[5]:
		if len(p[3])>0: DetectionTour2(len(p[3]),p,0)#Si la liste des mob n'est pas vide
		p[0].after(1000,DetectionTourPrincipal,p)
	elif not p[15]:p[0].after(100,DetectionTourPrincipal,p)

def DetectionTour2(imax,p,i):
	"""Fonction permettant de parcourir la liste des tour et de lancer  leur méthode detection
	toutes les 10 ms
	"""
	if not p[5]:
		#On met le try  au cas ou l'utilisateur supprime une tour pendant un parcour de liste
		try:p[3][i].detection(p)
		except IndexError:pass
		#On incremente i
		i+=1
		#Et on rapelle la fonction dans 10ms si on n'a pas atteind imax
		if i==imax:pass
		else:p[0].after(10,DetectionTour2,imax,p,i)
	elif not p[15]:p[0].after(100,DetectionTour2,imax,p,i)


#====== Fonction de gestion du temps ======
def temps(p,cent,sec,min):
	"""Fonction appellée toutes les 100ms et actualisant le temps affichée dans le jeu
	"""
	if not p[5]:
	
		p[19]+=10 # On ajoute 10 centièmes de seconde à la variable du temps passé (p19)
		
		cent+=10 # On fait de meme avec la variable des centièmes de seconde
		
		if cent == 100:
			#Si on atteint 100 centièmes alors on passe à la seconde supérieur
			cent=0
			sec+=1
			
		if sec == 60:
			#Si on atteint 60 secondes alors on passe à la minute supérieur
			sec=0
			min+=1
		
		#on actualise l'affichage du temps (p20) en spécifiant 2 décimales pour chaque composants
		p[20].config(text="{0:0=2d}:{1:0=2d}:{2:0=2d}".format  (min,sec,cent))
		
		#On rapelle la fonction aprés 100ms
		p[0].after(100,temps,p,cent,sec,min)
		
	elif not p[15]:
		p[0].after(100,temps,p,cent,sec,min)


#----------------------------------------------------------------------
#Définition des fonctions créant les interfaces et leurs fonctions associées
#----------------------------------------------------------------------

#====== Menu du jeu ======
def menu(f , frame_prec) :
	"""Fonction d'affichage du menu du jeu
	"""
	
	# On change le titre de la page
	f.title("Tower Defence - Menu")
	
	#On supprime la frame précedente si elle existe
	try:frame_prec.destroy()
	except AttributeError:pass

	M=Frame(f,width=900,height=600) #on déclare une frame pour contenir le menu
	M.pack_propagate(False)#permet de forcer la taille de la frame menu
	M.pack()
		
	#Image fond:
	Label(M,image=BGMenu).grid(row=0,column=0,rowspan=20,columnspan=7)
	
	#Bouttons :
	Button(M, text="Charger une partie", font='Times 12', width =15,command=lambda :charger_partie(f,M)).grid(row=17,column=0)
	Button(M, text="Nouvelle partie", font='Times 12', width =15,command=lambda :nouvelle_partie(f,M)).grid(row=18,column=0)
	Button(M, text="Quitter", font='Times 12', fg='#8B0000', width =15, command=lambda: sys.exit(0)).grid(row=19,column=0)
	
	Button(M, text="Accés au site", font='Times 12', width =15 , command=lambda :webbrowser.open_new('tw.lexcorp.fr')).grid(row=17,column=6)
	Button(M, text="Tutoriel (à venir)", font='Times 12', width =15).grid(row=18,column=6)
	Button(M, text="Editeur de carte", font='Times 12', width =15, command=lambda :  os.system("EditeurCarte.pyw")).grid(row=19,column=6) #EditeurCarte.pyw
	# les deux derniers boutons ne sont pas encore fonctionels
	
#Fonctions associées
def charger_partie(f , frame_prec):
	"""
		Fonction appelée si l'utilisateur choisi d'ouvrir une partie enregistrée
		Elle invite à choisir un fichier et relance la partie
	"""
	#Le bloc try permet de gérer quand l'utilisateur ferme la fenetre sans selectionner de fichier
	try:
		# On demande à l'utilisateur de choisir un fichier d'extension .twp (tower partie) en partant du dossier Parties
		dir=askopenfilename(title="Ouvrir la partie à charger",initialdir="Save/Parties",filetypes=[("Partie Tower Defence","*.twp")])
		
		# On lis le fichier et on extrait la sauvegarde
		with open(dir,'rb')as fichier:
			mon_pickler=Unpickler(fichier)
			sauvegarde=mon_pickler.load()
		
		#On récupère tous les éléments sauvegagerdé et on crée les variables qui n'avaiant pas besoin de l'être
		carte = sauvegarde[0]
		Selection=False
		LVague=sauvegarde[6]
		Argent=IntVar()
		Argent.set(sauvegarde[4])
		Vie=IntVar()
		Vie.set(sauvegarde[3])
		XP=IntVar()
		XP.set(sauvegarde[7])
		Pause=False
		Stop=False
		LCase=sauvegarde[5]
		cible=sauvegarde[8]
		temps_passe=sauvegarde[9]
		LMob=sauvegarde[1]
		LTour=sauvegarde[2]
		
		# on crée la fameuse liste p (voir haut de page)
		p=[f,'terrain',LMob,LTour,carte['Chemin'],Pause,Selection,Vie,Argent,'chateau','PlacerSelect',LCase,LVague,
		'CadreInfo','TourBouton',Stop,'CadreVague',XP,cible,temps_passe,'affiche_temp','bouton_option',gagner,carte,'jeu',dir]
		
		#On détruit la frame précédente
		frame_prec.destroy()
		
		#Et on lance la génération de l'interface de jeu
		creer_jeu(carte,p,dir=dir)
		
		#On relance toutes les entitées de la partie pour refaire bouger les mob, etc...
		for liste in(LCase,LMob,LTour,LVague):
			for objet in liste:
				objet.relancer(p)
		
		#On calcul du nombre de centièmes de secondes enregistrés les composant du temps
		cent=temps_passe
		sec=int(cent/100)
		cent-=sec*100
		min=int(sec/60)
		sec-=min*60
		# et on relance temps
		temps(p,cent,sec,min)

		# et enfin on relance la détection par les tours
		DetectionTourPrincipal(p)
		
	except FileNotFoundError: pass

def nouvelle_partie(f , frame_prec):
	"""
		Fonction appellée lorsque l'utilisateur choisi de commencer une nouvelle partie sur une carte
		On invite l'utilisateur à choisir une carte et lance la partie
	"""
	#Le bloc try permet de gérer quand l'utilisateur ferme la fenetre sans selectionner de fichier
	try:
		# On demande à l'utilisateur de choisir un fichier d'extension .twc (tower carte) en partant du dossier Cartes
		dir=askopenfilename(title="Ouvrir la carte à charger",initialdir="Save/Cartes",filetypes=[("Carte Tower Defence","*.twc")])
		
		# On lis le fichier et on extrait la carte
		with open(dir,'rb')as fichier:
			mon_pickler=Unpickler(fichier)
			carte=mon_pickler.load()
		
		#On crée les variables de la partie en utilisant la carte
		Selection=False
		LVague=deepcopy(carte["Vague"])
		Argent=IntVar()
		Argent.set(carte["Argent"])
		Vie=IntVar()
		Vie.set(carte["Vie"])
		XP=IntVar()
		XP.set(0)
		Pause=False
		Stop=False
		LCase=[]
		cible=0 # Variable contenant le mob ciblé
		temps_passe=0
		LMob=[]
		LTour=[]
		
		p=[f,'terrain',LMob,LTour,carte['Chemin'],Pause,Selection,Vie,Argent,'chateau','PlacerSelect',LCase,LVague,
		'CadreInfo','TourBouton',Stop,'CadreVague',XP,cible,temps_passe,'affiche_temp','bouton_option',gagner,carte,'jeu',dir]
		
		# On détruit la frame précédente
		frame_prec.destroy()
		
		# On crée l'interface de jeu
		creer_jeu(carte,p)
		
		#On affiche les cases du sol enregistées dans un dictionnaire associant
		#un tuple de coordonnées à un type de terrain
		for x in range(23):
			for y in range(21):
				t=carte["Sol"][(x,y)]
				p[11].append(Case(x,y,t,p))
		
		# On lance les vagues
		for vague in LVague:
			vague.lancer(p,p[16])
		
		#On lance le temps
		temps(p,0,0,0)
		
		# Et on lance la détection par les tours
		DetectionTourPrincipal(p)
		
	except FileNotFoundError: pass


#====== Fonction de création de l'interface de jeu ======
def creer_jeu(carte , p , dir=0) :
	"""
		Fonction créeant l'interface de jeu
	"""
	
	#On renomme la page
	p[0].title("Tower Defence - partie en cours ...")
	
	#On déclare un canvas pour contenir le jeu
	p[24]=Canvas(p[0],bg='#6b6b6b',highlightthickness=0)
	p[24].grid(row=0,column=0)
	jeu=p[24]
	
	#====== Canvas contenant le terrain======
	p[1]=Canvas(jeu, width=635, height=577, bg='green',highlightthickness=0)
	p[1].grid(row=0,column=0, rowspan=9, padx=5, pady=5)
	p[1].pack_propagate(False)

	
	#====== Canvas d'infos ====== (permet d'afficher des infos et des
	#option pour les objets sélectionnés
	p[13]=Frame(jeu, width=200, height=220, bg='#6b6b6b')
	p[13].grid(row=5, column=1, columnspan=3, padx=7, pady=2.5, ipadx=2.5, ipady=2.5)	
	p[13].grid_propagate(False)#permet de forcer la taille de la frame menu

	
	#====== Canvas de défilement des vagues ====== 
	p[16]=Canvas(jeu, width=200, height=50, bg='grey',highlightthickness=0)
	p[16].grid(row=6, column=1, columnspan=3, padx=7, pady=2.5)
	
	
	#====== LabelFrame d'infos générales sur le jeu ====== 
	Infos=LabelFrame(jeu,text="Infos",padx=5,pady=5,width=200,height =110,bg='#6b6b6b')
	Infos.grid(row=0,column=1,rowspan=2,columnspan=3)
	Infos.grid_propagate(0)#permet de fixer la taille
		#Vie
	Label(Infos, text='Vie :',bg='#6b6b6b').grid(row=0, column=0, sticky=E)
	Label(Infos, textvariable=p[7],bg='#6b6b6b').grid(row=0, column=1, sticky=W)
		#Argent
	Label(Infos, text='Argent :',bg='#6b6b6b').grid(row=1, column=0, sticky=E)
	Label(Infos, textvariable=p[8],bg='#6b6b6b').grid(row=1, column=1, sticky=W)
		#XP
	Label(Infos, text='XP :',bg='#6b6b6b').grid(row=2, column=0, sticky=E)
	Label(Infos, textvariable=p[17],bg='#6b6b6b').grid(row=2, column=1, sticky=W)
		#Temps
	Label(Infos, text='Temps :',bg='#6b6b6b').grid(row=3, column=0, sticky=E)
	p[20]=Label(Infos, text="00:00:00",bg='#6b6b6b')
	p[20].grid(row=3, column=1, sticky=E)
	
	
	#====== LabelFrame des boutons des tours ====== 
	# Variable contenat le choix de tour à placer
	p[10]=IntVar()
	
	# Label frame contenant les boutons
	Tours=LabelFrame(jeu, text='Tours',padx=5,pady=5,width=200,height =100,bg='#6b6b6b')
	Tours.grid(row=2, column=1,rowspan=2,columnspan=3)
	Tours.grid_propagate(0)
		
	#=>Boutons (radio-boutons)
	p[14]=[]#On les enregistre dans une liste
		#Tour1
	p[14].append(Radiobutton(Tours, variable=p[10], value=1,indicatoron=0,image=Tour1,text=IT[1]["prix"],compound=TOP,command=lambda :PlacerTour(p,1)))
	p[14][0].grid(row=0, column=1,padx=10)
	p[0].bind_all("1",lambda event:PlacerTourBis(p,1))
		#Tour2
	p[14].append(Radiobutton(Tours, variable=p[10], value=2,indicatoron=0,image=Tour2,text=IT[2]["prix"],compound=TOP,command=lambda :PlacerTour(p,2)))
	p[14][1].grid(row=0, column=2,padx=10)
	p[0].bind_all("2",lambda event:PlacerTourBis(p,2))
		#Tour3
	p[14].append(Radiobutton(Tours, variable=p[10], value=3,indicatoron=0,image=Tour3,text=IT[3]["prix"],compound=TOP,command=lambda :PlacerTour(p,3)))
	p[14][2].grid(row=0, column=3,padx=10)
	p[0].bind_all("3",lambda event:PlacerTourBis(p,3))
	
	VerificationPrix(p)# On lance une vérification des prix pour désactiver les boutons trop cher
	
	
	#====== Bouton Option ====== 
	p[21]=Button(jeu, text="Option", font='Times 12', width=15, command=lambda :pausejeu(f,p,carte,jeu,dir))
	p[21].grid(row=7, column=1, columnspan=3, padx=5, pady=2.5)
	
	
	#====== Association de fonctions à des variables ====== 
	# Qd c'est varaibles sont actualisées on lance la fonction associée
	p[8].trace_variable('w',lambda a,b,c: VerificationPrix(p))
	p[7].trace_variable('w',lambda a,b,c: Perdu(f,p,carte,jeu))


#====== Menu d'option (pause) ======
def pausejeu(f , p , carte , jeu , dir) :
	"""
		Fonction créant l'interface de pose
		Elle met le jeu en pause, désactve les boutons et affiche un menu
	"""
	
	#On change le nom de la page
	p[0].title("Tower Defence - partie en pause")

	#On désactives les boutons
	p[21].config(state=DISABLED)
	p[14][0].config(state=DISABLED)
	p[14][1].config(state=DISABLED)
	p[14][2].config(state=DISABLED)
	
	#On met le jeu sur pose
	p[5]=True
	#On déselectionne tout objet sélectionné
	if p[6]!=0 and p[6].selected==1:p[6].select(p)
	
	#====== Titre du menu ======
	fond_titre=p[1].create_image(317,88,image=fond_option_titre)# Image de fond
	titre=Label(p[1],text='Options',fg='#0094dc',bg='black',font=option_style)
	titre.pack(side=TOP,pady=50)
	
	#====== Menu ======
	fond_bouton=p[1].create_image(317,374,image=fond_option_bouton)# Image de fond
	#On crée une frame pour contenir les boutons
	Pause=Frame(p[1],bg='black',width=200,height=250)
	Pause.pack(side=BOTTOM,pady=75)
	Pause.pack_propagate(False)
	
	Button(Pause, text="Reprendre" , font='Times 15', fg='#0094dc', bd=2 , relief=FLAT , overrelief=GROOVE , activebackground='#0094dc' , activeforeground='black' , width=15 , bg='black' , command=lambda : reprendre(p,titre,Pause,fond_bouton,fond_titre)).pack(pady=5)
	Button(Pause, text="Recommencer" , font='Times 15', fg='#0094dc', bd=2 , relief=FLAT , overrelief=GROOVE , activebackground='#0094dc' , activeforeground='black' , width=15 , bg='black' , command=lambda : recommencer(f,p,carte,jeu)).pack(pady=5)
	Button(Pause, text="Sauvegarder" , font='Times 15', fg='#0094dc', bd=2 , relief=FLAT , overrelief=GROOVE , activebackground='#0094dc' , activeforeground='black' , width=15 , bg='black' , command=lambda :sauvegarder_partie(carte,p,dir)).pack(pady=5)
	Button(Pause, text="Menu" , font='Times 15', fg='#0094dc', bd=2 , relief=FLAT , overrelief=GROOVE , activebackground='#0094dc' , activeforeground='black' , width=15 , bg='black' , command=lambda :pause_vers_menu(f,jeu,p)).pack(pady=5)
	Button(Pause, text="Quitter" , font='Times 15', fg='#0094dc', bd=2 , relief=FLAT , overrelief=GROOVE , activebackground='#0094dc' , activeforeground='black' , width=15 , bg='black' , command=lambda: sys.exit(0)).pack(pady=5)	

#Fonctions associées 
#PS: certaines de ces fonctions sont aussi utilisées pour le menu perdu et le menu gagné
def reprendre(p , titre , Pause , fond_bouton , fond_titre) :
	"""
		Fonction nettoyant l'interface de pause et enlèvant la pause
	"""
	#On change le nom de la page
	p[0].title("Tower Defence - partie en cours ...")
	
	#On supprime les élément de l'interface
	p[1].delete(fond_bouton)
	p[1].delete(fond_titre)
	titre.destroy()
	Pause.destroy()
	
	#on réactives les boutons
	p[21].config(state=ACTIVE)
	VerificationPrix(p) # Vérification permet d'activer seulement les bons boutons
	
	# On enlève la pause
	p[5]=False

def recommencer(f , p , carte , jeu) :
	"""
		Fonction permettant de recommencer la partie grace à la carte passée en argument
		Elle reprend le meme sisteme que nouvelle_partie
	"""
	p[15]=True
	jeu.destroy()
	
	Selection=False
	LVague=deepcopy(carte["Vague"])
	Argent=IntVar()
	Argent.set(carte["Argent"])
	Vie=IntVar()
	Vie.set(carte["Vie"])
	XP=IntVar()
	XP.set(0)
	Pause=False
	Stop=False
	LCase=[]
	cible=0
	temps_passe=0
	LMob=[]
	LTour=[]
	
	p=[f,'terrain',LMob,LTour,carte['Chemin'],Pause,Selection,Vie,Argent,'chateau','PlacerSelect',LCase,LVague,
	'CadreInfo','TourBouton',Stop,'CadreVague',XP,cible,temps_passe,'affiche_temp','bouton_option',gagner,carte,'jeu',dir]
	creer_jeu(carte,p)
	for x in range(23):
		for y in range(21):
			t=carte["Sol"][(x,y)]
			p[11].append(Case(x,y,t,p))
	
	for vague in LVague:
		vague.lancer(p,p[16])
	
	temps(p,0,0,0)
	DetectionTourPrincipal(p)

def sauvegarder_partie(carte , p , dir):
	"""
		Fonction permettant d'enregistrer la partie en cours
	"""
	#Si il y a une direction spécifiée on par d'elle
	if dir!=0:
		dir= asksaveasfilename (title="Sauvegarder partie",initialdir=dir,initialfile=dir,filetypes=[("Partie Tower Defence","*.twp")])
	#Sinon on part du dossier Save/Parties
	else:
		dir= asksaveasfilename (title="Sauvegarder partie",initialdir='Save/Parties',filetypes=[("Partie Tower Defence","*.twp")])
		
	if dir[len(dir)-4:]!=".twp": dir= dir+".twp"#permet de rajouter l'extension à la direction
	
	# On crée la liste à sauvegarder
	# p=[f,terrain,LMob,LTour,carte['Chemin'],Pause,Selection,Vie,Argent,0,PlacerSelect,LCase,LVague,CadreInfo,'TourBouton',Stop,CadreVague,XP,cible,temps_passe]
	sauvegarde =[carte,p[2],p[3],p[7].get(),p[8].get(),p[11],p[12],p[17].get(),p[18],p[19]]
	
	# Et on la met dans un fichier indiqué par dir
	with open(dir,'wb')as fichier:
		mon_pickler=Pickler(fichier)
		mon_pickler.dump(sauvegarde)

def pause_vers_menu(f , jeu , p):
	"""Fonction de transition pause => menu
	"""
	p[15]=True#On met stop=True pour stopper toutes boucles d'arrière plan
	menu(f,jeu)


#====== Fonctions d'affichage du menu perdu ======
def Perdu (f , p , carte , jeu):
	"""Fonction appelée à chaque actualisation de la IntVar contenant le nombre de vies (p7)
		 Si la vie est à 0:Elle stop les jeu et toutes les animation et lance l'affichage du menu perdu
	"""
	if p[7].get()<=0:#Si la vie est à 0
		
		#====== Arrêt detoutes fonctionnalitées de la partie ======
		#On met le jeu sur pause et sur stop pour stopper toute boucle d'arrière plan
		p[5]=True
		p[15]=True
		
		#On désactive tous les boutons du menu de droite
		#les boutons pour poser le tours
		p[14][0].config(state=DISABLED)
		p[14][1].config(state=DISABLED)
		p[14][2].config(state=DISABLED)
		#et les boutons pour les options
		p[21].config(state=DISABLED)
		
		#Si un objet est sélectionné alors on le déselectionne et appelant sa méthode select
		if p[6]!=0 and p[6].selected==1:p[6].select(p)
		
		#====== Structuration du menu Perdu ======
		#On change le titre de la fenetre
		p[0].title("Tower Defence - partie perdue")
		
		#On affiche le fond du menu
		p[1].create_rectangle(0,0,700,700,fill='black')
		p[1].create_image(320,291,image=FondPerdu)
		
		 #On lance la fonction d'animation du "Game Over"
		text_perdu(-50,p[1].create_image(303,-50,image=GameOver),p)

		#Et aprés 1 seconde (le temps que le titre descende) on lance la fonction
		#qui affiche les boutons
		p[0].after(1000,boutons_perdu,f,p,carte,jeu)
		
def text_perdu (i , img , p):
	"""Fonction permettant l'animation du titre du menu Perdu
	"""
	if i<70:
		#Tant que l'image n'est pas arrivée à l'ordonnée de 70px
		i+=5#on incremente l'ordonnée de 5
		p[1].coords(img,303,i)#on actualise la position de l'image
		p[0].after(30 , text_perdu , i , img , p )#et on rapelle la fonction aprés 30ms

def boutons_perdu(f , p , carte , jeu) :
	"""Fonction affichant les boutons du menu perdu
	"""
	#On créer l'image de fond des boutons
	p[1].create_image(317,400,image=fond_perdu_bouton)
	#On crée un frame  pour contenir les boutons
	GameOver=Frame(p[1] , bg='black')
	#On la place à 100px du bas du cadre
	GameOver.pack(side= BOTTOM,pady=100)
	#Et on y ajoutes les différents boutons
	Button(GameOver, text="Recommencer" , font='Times 15' , fg='#8B0000' , bd=2 , width=15 , bg='black' , relief=FLAT , overrelief=GROOVE , activebackground='#8B0000' , activeforeground='black' , command=lambda :recommencer(f,p,carte,jeu)).pack(pady=5)
	Button(GameOver, text="Menu" , font='Times 15' , fg='#8B0000',bd=2 , width =15 , bg='black' , relief=FLAT , overrelief=GROOVE , activebackground='#8B0000' , activeforeground='black', command=lambda :menu(f,jeu)).pack(pady=5)
	Button(GameOver, text="Quitter" , font='Times 15' , fg='#8B0000' , bd=2 , width =15 , bg='black' , relief=FLAT , overrelief=GROOVE , activebackground='#8B0000' , activeforeground='black' , command=lambda: sys.exit(0)).pack(pady=5)


#====== Fonction d'affichage du menu gagné ======
def gagner (f , p , carte , jeu , dir):
	"""
		fonction appelée quand on gagne pour créer l'interface gagné
	"""
	# On change le titre de la page
	p[0].title("Tower Defence - partie gagnée")
	
	#On stop la partie
	p[5]=True
	p[15]= True
	
	#On désactive les boutons
	p[21].config(state=DISABLED)
	p[14][0].config(state=DISABLED)
	p[14][1].config(state=DISABLED)
	p[14][2].config(state=DISABLED)
	# On désélectionne les objets sélectionnés
	if p[6]!=0 and p[6].selected==1:p[6].select(p)
	
	#====== Titre ======
	titre=Label(p[1],text='Game Over',fg='#0094dc',bg='black',font=option_style)
	titre.pack(side=TOP,pady=50)
	
	#====== Menu ======
	Cadre=Frame(p[1],bg='black')
	Cadre.pack(side=BOTTOM,pady=20)
	
	#On affiche les résultats de la partie
	Label(Cadre,text="You Won!",fg='#0094dc',bg='black').pack(expand=YES,fill=X)
	Label(Cadre,text="Congratulation",fg='#0094dc',bg='black').pack(expand=YES,fill=X)
	Label(Cadre,text="Your score:",fg='#0094dc',anchor=W,bg='black').pack(expand=YES,fill=X)
	
	#Avec toutes les données
	Label(Cadre,text="XP = {} x1".format(p[17].get()),fg='#0094dc',bg='black').pack(expand=YES,fill=X)
	Label(Cadre,text="Vie = {} x1000".format(p[7].get()),fg='#0094dc',bg='black').pack(expand=YES,fill=X)
	Label(Cadre,text="Argent = {} x2".format(p[8].get()),fg='#0094dc',bg='black').pack(expand=YES,fill=X)
	
	#On calcul le temps économisé
	tps_passe=p[19]/100
	tps_total=0
	for vague in p[12]:
		tps_total+=vague.DureeFixe
	tps=ceil((1-tps_passe/tps_total)*100)
	Label(Cadre,text="Temps économisé = {}% x4000".format(tps),fg='#0094dc',bg='black').pack(expand=YES,fill=X)
	
	#On calcul le score
	score=p[17].get()+p[7].get()*1000+p[8].get()*2+tps*4000
	Label(Cadre,text="Score = {}".format(score),fg='#0094dc',bg='black').pack(expand=YES,fill=X)
	
	#Boutons
	Partager=0
	Partager=Button(Cadre, text="Partager", font='Times 15', fg='#0094dc',bd=2,relief=FLAT,overrelief=GROOVE,activebackground='#0094dc',activeforeground='black', width=15,bg='black',command=lambda :creerperso(p,score,Partager))
	Partager.pack(pady=5)
	Button(Cadre, text="Recommencer", font='Times 15', fg='#0094dc',bd=2,relief=FLAT,overrelief=GROOVE,activebackground='#0094dc',activeforeground='black', width=15,bg='black',command=lambda : recommencer(f,p,carte,jeu)).pack(pady=5)
	Button(Cadre, text="Menu", font='Times 15', fg='#0094dc',bd=2,relief=FLAT,overrelief=GROOVE,activebackground='#0094dc',activeforeground='black', width =15,bg='black',command=lambda :pause_vers_menu(f,jeu,p)).pack(pady=5)
	Button(Cadre, text="Quitter", font='Times 15', fg='#0094dc',bd=2,relief=FLAT,overrelief=GROOVE,activebackground='#0094dc',activeforeground='black', width =15, command=lambda: sys.exit(0),bg='black').pack(pady=5)	


#====== Fonctions permettant l'affichage de la fenetre d'enregistrement des scores en ligne ======
def creerperso (p , score , bouton) :
	"""
		Fonction appellée pour partager le score sur le site
	"""
	perso = Toplevel() #On déclare une nouvelle fenetre
	perso.title("Enregistre ton score !")
	perso.iconbitmap('img/Icone.ico')
	
	#Texte :
	Label(perso, text = 'Ton score est de : ').pack()
	Label(perso, text = score, font='bold').pack()
	Label(perso, text = 'Rentre ton pseudo pour publier ton classement en ligne !').pack(padx=5, pady=5)
	
	#Endroi où l'ont rentre le texte :
	entre = Entry(perso)
	entre.pack(padx=10, pady=5)
	
	#Bouttons :
	Button(perso, text="C'est bon !", font='Times 12', width =15, command=lambda: publish(score,entre.get(),p[19],perso,bouton)).pack(padx=5, pady=5)#entre.get()
	Button(perso, text="Non merci ;)", font='Times 12', width =15, command=perso.destroy).pack(padx=5, pady=5)	
	
	#Crédits :
	Label(perso, text='Jeu crée par des gens').pack(side=BOTTOM)

def publish( score , pseudo , tps , perso , bouton ):
	"""Fonction permettant d'enregistrer le score sur le site
	"""
	#on ouvre une page du site en passant des arguments pour transmettre le score le pseudo et le temps
	#Cette technique est trés peu sécurisée mais elle suffit pour le moment
	webbrowser.open('tw.lexcorp.fr/towerAjout_post.php?scor={}&pseud={}&tps={}'.format(score,pseudo,tps))
	
	#On détruit le toplevel pour enregistrer le score
	perso.destroy()
	#Et on désactive le bouton partagé
	bouton.config(state=DISABLED)


#----------------------------------------------------------------------
#Lancement du jeu
#----------------------------------------------------------------------
#On crée un menu
menu(f,a)

f.mainloop()
